<?php
/**
 * Welcome page
 *
 * @package Tutor\Views
 * @subpackage Tutor\Welcome
 * @author Themeum <support@themeum.com>
 * @link https://themeum.com
 * @since 1.0.0
 */

$image_url = 'https://api.tutorlms.com/wp-json/restapi/v1/tutor-assets/welcome';
?>

<style type="text/css">
.tutor-welcome-card {
	background: #FAFDFF;
	border-radius: 18px;
}

.tutor-lms-welcome-page img {
	display: block;
}

.tutor-lms-welcome-page .tutor-header-section {
	margin-left: -20px;
	background-color: #0049F8;
}

.tutor-lms-welcome-page .tutor-fs-3 {
	line-height: 1.2;
}
</style>

<div class="tutor-lms-welcome-page">
	<section class="tutor-header-section">
		<div class="tutor-container">
			<div class="tutor-row">
				<div class="tutor-col-xl-6" style="padding-top: 150px;">
					<div class="tutor-mb-36">
						<a href="https://www.themeum.com/product/tutor-lms/">
							<svg xmlns="http://www.w3.org/2000/svg" width="310" height="64" fill="none"><g fill="#fff" clip-path="url(#a)"><path d="M73.888 52.544V16.96H63.14c-1.214 0-1.666-.768-1.666-2.635v-1.653c0-1.877.452-2.645 1.666-2.645h29.732c1.225 0 1.666.768 1.666 2.645v1.653c0 1.867-.559 2.635-1.666 2.635H82.219v35.584c0 1.216-1 1.877-3.332 1.877H77.22c-2.333-.021-3.333-.661-3.333-1.877ZM142.821 38.112c0-10.464 5.224-16.192 15.049-16.192 9.824 0 14.984 5.728 14.984 16.192s-5.17 16.192-14.93 16.192-15.103-5.728-15.103-16.192Zm21.982 0c0-6.72-2.15-10.133-6.879-10.133-4.73 0-6.998 3.413-6.998 10.133 0 6.72 2.15 10.133 6.998 10.133 4.847 0 6.879-3.445 6.879-10.133ZM177.358 21.92h5.213a.88.88 0 0 1 .637.253.86.86 0 0 1 .255.632l.333 4.619c1.548-2.528 3.773-4.736 6.987-4.736 2.892 0 3.666 1.067 3.666 2.976 0 1.216-.667 4.63-1.774 4.63a23.667 23.667 0 0 0-3.106-.555c-2.892 0-4.891 2.538-5.375 3.413v19.392c0 1.216-1 1.877-3.44 1.877h-.999c-2.333 0-3.332-.661-3.332-1.877V22.805a.862.862 0 0 1 .272-.645.884.884 0 0 1 .663-.24ZM209.873 52.437V11.35c0-.885.774-1.322 2.44-1.322h.516c1.774 0 2.44.544 2.44 1.322v38.219h17.199c.892 0 1.225.555 1.225 1.877v.992c0 1.323-.333 1.867-1.225 1.867h-20.714a1.656 1.656 0 0 1-1.419-.458 1.622 1.622 0 0 1-.462-1.409ZM274.7 9.91h-2.15a2.77 2.77 0 0 0-2.655 1.066l-13.404 22.837-13.436-22.794c-.322-.662-1.075-1.067-2.655-1.067h-2.225c-1.773 0-2.44.555-2.44 1.323V52.98c0 .886.774 1.323 2.44 1.323h.452c1.784 0 2.45-.544 2.45-1.323V22.048c.02-1.139-.02-2.278-.118-3.413l.226-.107c.409.973.929 1.896 1.548 2.752l11.211 19.253c.094.263.278.484.519.626.242.143.526.197.803.153h2.451a1.556 1.556 0 0 0 1.333-.779l10.985-18.837c.559-.875 1-1.76 1.559-2.752l.215.117c-.108 1.067-.108 2.304-.108 3.414V52.98c0 .886.774 1.323 2.44 1.323h.441c1.784 0 2.451-.544 2.451-1.323v-41.6c.215-.917-.559-1.472-2.333-1.472ZM283.471 51.328c-.784-.544-1.225-1.067-1.225-1.536 0-.992 1.548-3.413 2.214-3.413.486.126.94.351 1.333.661a19.355 19.355 0 0 0 9.556 2.528c4.772 0 8.212-2.976 8.212-7.381 0-5.067-4.665-6.603-9.545-8.48-5.374-2.134-10.996-4.075-10.996-12.342 0-6.72 5.557-11.562 13.974-11.562 2.665 0 6.771.768 8.889 2.208a2.143 2.143 0 0 1 1.215 1.653c0 .981-1.333 3.296-2 3.296a3.875 3.875 0 0 1-1.666-.768 13.765 13.765 0 0 0-6.546-1.653c-4.772 0-8.105 2.538-8.105 7.05 0 4.512 3.999 5.728 8.546 7.467 5.664 2.133 11.996 4.63 11.996 13.227 0 7.466-5.558 12.117-13.974 12.117-5.45 0-9.889-1.525-11.878-3.072ZM139.274 47.701c-.71.126-1.429.197-2.15.214-1.666 0-2.665-.768-2.665-3.414V28.085h3.321a1.706 1.706 0 0 0 1.169-.493c.311-.308.489-.724.497-1.16v-3.083a1.69 1.69 0 0 0-.5-1.157 1.714 1.714 0 0 0-1.166-.496h-3.321v-6.763a1.691 1.691 0 0 0-.504-1.15 1.716 1.716 0 0 0-1.162-.492h-4.665c-.43.018-.837.198-1.138.503a1.68 1.68 0 0 0-.486 1.14v6.72h-2.149c-.439.01-.856.188-1.166.496-.311.307-.49.722-.5 1.157v3.082c.008.436.186.852.497 1.16.31.309.729.486 1.169.494h2.149v16.565c0 7.05 3.892 9.6 8.879 9.6 1.892 0 5.557-.224 5.557-2.645.108-.448-.559-3.862-1.666-3.862ZM117.852 21.813c.438.011.855.189 1.166.497.31.307.489.722.5 1.157V52.65a1.69 1.69 0 0 1-.5 1.157 1.718 1.718 0 0 1-1.166.496h-4.225a1.716 1.716 0 0 1-1.166-.496 1.69 1.69 0 0 1-.5-1.157v-3.083a12.876 12.876 0 0 1-4.314 3.42 12.98 12.98 0 0 1-5.36 1.316c-6.45 0-9.674-3.413-9.674-10.133V23.467c.01-.435.19-.85.5-1.157.31-.308.728-.486 1.166-.497h4.665c.445 0 .872.173 1.19.483.317.309.5.73.508 1.17v19.606c0 2.976 1.548 4.63 4.773 4.63 2.666 0 4.88-1.985 6.105-3.862V23.467c.009-.436.187-.852.498-1.16.31-.309.729-.485 1.168-.494h4.666Z"/><path fill-rule="evenodd" d="M12.963 40.757a3.236 3.236 0 0 1-2.164-.935 3.189 3.189 0 0 1-.942-2.147v-7.051c0-.818.327-1.602.91-2.18a3.119 3.119 0 0 1 2.196-.903c.824 0 1.614.325 2.197.903a3.07 3.07 0 0 1 .91 2.18v7.05a2.99 2.99 0 0 1-.887 2.203 3.033 3.033 0 0 1-2.22.88M35.386 40.757a3.116 3.116 0 0 1-2.221-.888 3.069 3.069 0 0 1-.918-2.194v-7.051c0-.818.327-1.602.91-2.18a3.119 3.119 0 0 1 2.196-.903c.824 0 1.614.325 2.197.903a3.07 3.07 0 0 1 .91 2.18v7.05a3.05 3.05 0 0 1-.907 2.184 3.098 3.098 0 0 1-2.2.9" clip-rule="evenodd"/><path fill-rule="evenodd" d="M6.75 25.333a7.825 7.825 0 0 1 2.797-3.222 7.91 7.91 0 0 1 4.083-1.29 7.95 7.95 0 0 1 5.5 2.456 7.828 7.828 0 0 1 2.164 5.587v14.432c.095.692.44 1.327.97 1.786a2.926 2.926 0 0 0 3.83 0c.531-.459.876-1.094.972-1.786V28.864a7.817 7.817 0 0 1 2.157-5.586 7.94 7.94 0 0 1 5.496-2.457 7.223 7.223 0 0 1 3.962 1.102 7.142 7.142 0 0 1 2.702 3.08 19.078 19.078 0 0 1-.684 18.675 19.28 19.28 0 0 1-6.97 6.735 19.463 19.463 0 0 1-9.393 2.517 19.466 19.466 0 0 1-9.44-2.337 19.288 19.288 0 0 1-7.099-6.6A19.075 19.075 0 0 1 6.75 25.333ZM18.961 6.4H29.84v4.17a24.102 24.102 0 0 0-5.546-.66 29.087 29.087 0 0 0-5.375.554l.043-4.064Zm29.527 29.515c0-.662.108-1.216.108-1.878a24.06 24.06 0 0 0-3.349-12.183 24.301 24.301 0 0 0-9.077-8.851V6.4h4.676c.855 0 1.675-.337 2.28-.937.605-.6.945-1.414.945-2.263s-.34-1.663-.945-2.263A3.237 3.237 0 0 0 40.846 0H7.857c-.86.043-1.67.409-2.269 1.022a3.358 3.358 0 0 0-.955 2.285c0 .848.34 1.662.944 2.262.605.6 1.425.938 2.28.938h4.773v6.506a24.212 24.212 0 0 0-7.525 6.362 24 24 0 0 0-4.342 8.812 23.895 23.895 0 0 0-.44 9.8 23.965 23.965 0 0 0 3.536 9.16c9.04 15.2 33.526 16.746 41.856 16.853a3.238 3.238 0 0 0 2-.768 2.685 2.685 0 0 0 .773-1.984V35.915Z" clip-rule="evenodd"/></g><defs><clipPath id="a"><path fill="#fff" d="M0 0h309.333v64H0z"/></clipPath></defs></svg>
						</a>
					</div>
					<div class="tutor-fs-3 tutor-color-white" style="opacity: 0.7;">
						Welcome to Tutor LMS 2.0: Redefining eLearning on WordPress
					</div>
				</div>

				<div class="tutor-col-xl-6">
					<svg xmlns="http://www.w3.org/2000/svg" width="746" height="645" fill="none"><path fill="#0735A4" d="M335 191.081s3.878-51.025 37.345-84.784c0 0-12.2 54.978-37.345 84.784Z"/><path fill="#000" d="M307.405 118.17s22.181 1.287 29.922 17.011c-.008-.023-24.253-7.238-29.922-17.011Z"/><path fill="#BB8874" d="M366.605 113.745a16.654 16.654 0 0 1-.085-9.695c1.427-4.813 2.567-13.702-2.373-25.575-7.647-18.39 7.407-35.347 4.777-37.501-2.629-2.155-14.821 1.674-20.793 19.824 0 0-1.194 5.495-.954 8.362 0 0-6.158-.24-5.258 8.959.074 4.033.513 8.05 1.31 12.005.608 3.675.027 7.449-1.659 10.772a12.843 12.843 0 0 0-1.203 6.525c.474 6.502 1.769 19.111 4.894 24.443 4.305 7.339 7.128 36.882 7.128 36.882l15.822-49.801-1.606-5.2Z"/><path fill="#B17056" d="m325.414 154.959 13.549-37.316a22.497 22.497 0 0 0 1.296-6.021c.147-2.054.535-4.798 1.504-6.425 1.699-2.868 2.622-7.75 1.831-11.912-.791-4.161-2.242-13.95-1.055-19.723 0 0-3.172-6.867-7.663-2.906 0 0-4.653-25.071-14.527-30.349-9.873-5.278-.775 18.08-2.373 33.387-1.598 15.306-6.344 19.374-3.436 34.44l-9.245 27.977 20.119 18.848Z"/><path fill="#3F1803" d="M187.654 203.419a3.1 3.1 0 0 1-1.691-2.526c-.163-1.047-.046-2.124-.217-3.178-.349-2.224-1.916-4.061-3.506-5.665-3.73-3.774-8.089-7.176-10.346-11.981a16.662 16.662 0 0 1-1.551-8.029 11.047 11.047 0 0 1 2.327-6.526 6.608 6.608 0 0 1 6.29-2.325c-3.211-4.998-6.352-7.974-2.397-12.399a19.949 19.949 0 0 1 5.623-4.154c2.327-1.217 8.532-6.317 11.184-6.417 2.251.027 4.488.35 6.655.961 6.848 1.55 14.325 2.72 20.677-.295 1.551-.728 3.102-1.712 4.785-1.658a8.095 8.095 0 0 1-1.652 5.799 8.108 8.108 0 0 1-5.204 3.051c2.327.868 4.654 2 6.205 3.875 1.551 1.876 2.218 4.751.985 6.89-1.233 2.139-4.654 2.875-6.267 1.03 0 0-5.041-5.37-16.931-5.006 0 0-7.5.915-4.212 8.773 0 0 2.381 4.572.187 5.673-2.195 1.1-2.56 4.2-2.56 4.2s-1.877 2.658-7.911-1.798a.777.777 0 0 0-.946 0c-1.474 1.132-5.538 5.014-1.551 10.951a22.224 22.224 0 0 0 3.567 3.1c1.373.775 4.483 3.976 2.513 8.959a77.396 77.396 0 0 1-4.056 8.695Z"/><path fill="#3F1803" d="M187.856 203.078c-1.683-.713-1.551-2.829-1.629-4.34a8.236 8.236 0 0 0-1.551-4.487 26.753 26.753 0 0 0-3.211-3.542c-1.156-1.123-2.327-2.224-3.49-3.355a26.71 26.71 0 0 1-5.763-7.564 15.629 15.629 0 0 1-1.031-10.432 8.565 8.565 0 0 1 2.83-4.564 6 6 0 0 1 4.887-1.256.393.393 0 0 0 .434-.573c-1.218-1.891-2.684-3.705-3.622-5.766a5.69 5.69 0 0 1-.566-2.596 5.25 5.25 0 0 1 1.062-2.728 16.655 16.655 0 0 1 5.771-4.697 41.505 41.505 0 0 0 3.73-2.371c1.474-1.023 2.955-2.046 4.514-2.945a13.955 13.955 0 0 1 2.04-1.008 5.27 5.27 0 0 1 2.172-.279c2.66.109 5.25.922 7.849 1.457 2.43.521 4.895.868 7.375 1.039 2.707.195 5.427-.04 8.059-.698a20.603 20.603 0 0 0 3.816-1.472c1.264-.636 2.536-1.341 3.994-1.318l-.388-.387a7.745 7.745 0 0 1-1.549 5.517 7.758 7.758 0 0 1-4.919 2.946.389.389 0 0 0-.36.625.39.39 0 0 0 .259.15c2.66.999 5.507 2.418 6.841 5.076 1.148 2.263.977 5.425-1.552 6.641a3.74 3.74 0 0 1-3.102.117 4.08 4.08 0 0 1-.993-.775 12.134 12.134 0 0 0-1.962-1.488 24.827 24.827 0 0 0-11.479-3.441 19.692 19.692 0 0 0-3.761-.054 7.379 7.379 0 0 0-3.498 1.534 5.124 5.124 0 0 0-1.815 3.805 11.36 11.36 0 0 0 1.226 4.743 8.83 8.83 0 0 1 .697 2.457 2.89 2.89 0 0 1-.093 1.24 1.49 1.49 0 0 1-.775.775 5.855 5.855 0 0 0-2.56 4.27c0 .194 0 .24 0 0 0-.054.086-.062 0 0-.072.058-.14.123-.201.194l-.109.077-.233.124a2.491 2.491 0 0 1-.589.186c-1.854.349-3.878-.837-5.305-1.805-.543-.357-1.117-.985-1.815-.876a2.054 2.054 0 0 0-.969.581 9.681 9.681 0 0 0-1.505 1.635 7.363 7.363 0 0 0-1.326 5.766 8.688 8.688 0 0 0 1.66 3.767c.481.538.999 1.043 1.551 1.511a18.462 18.462 0 0 0 2.326 1.806 6.114 6.114 0 0 1 1.552 1.55c1.466 2.123 1.419 4.649.496 6.974a78.666 78.666 0 0 1-3.366 7.355c-.186.357-.372.713-.574 1.07-.202.356.427.829.667.387.776-1.348 1.443-2.751 2.094-4.154a89.408 89.408 0 0 0 1.893-4.363 9.12 9.12 0 0 0 .729-4.053 7.432 7.432 0 0 0-2.568-5.069c-.628-.527-1.365-.914-2.001-1.449a28.232 28.232 0 0 1-2.101-1.992 5.05 5.05 0 0 1-.776-1.232 8.804 8.804 0 0 1-.776-1.999 6.424 6.424 0 0 1 .093-3.403 7.567 7.567 0 0 1 2.762-3.828c.341-.24.589 0 .884.209.294.21.713.496 1.086.721.559.354 1.142.67 1.745.945a8.035 8.035 0 0 0 2.606.721 3.213 3.213 0 0 0 2.52-.775.838.838 0 0 0 .155-.186s.078-.271.055-.17c-.024.1 0-.148 0-.194a6.886 6.886 0 0 1 .853-2.286 3.86 3.86 0 0 1 1.07-1.17 4.01 4.01 0 0 0 1.086-.814 3.216 3.216 0 0 0 .38-2.441c-.233-1.512-1.016-2.798-1.466-4.232-.52-1.651-.667-3.549.411-5.022a5.483 5.483 0 0 1 2.761-1.86 7.69 7.69 0 0 1 1.001-.256h.077c.776-.046 1.552 0 2.288 0a24.952 24.952 0 0 1 12.239 3.279c.716.423 1.387.919 2.001 1.48.272.295.58.555.915.775a4.18 4.18 0 0 0 2.994.418 4.86 4.86 0 0 0 3.793-5.107c-.109-2.852-1.97-5.153-4.305-6.618a20.673 20.673 0 0 0-3.808-1.806l-.101.775a8.53 8.53 0 0 0 7.244-9.238.394.394 0 0 0-.388-.387 7.77 7.77 0 0 0-3.49.968 27.064 27.064 0 0 1-3.575 1.55 22.86 22.86 0 0 1-7.454 1 43.82 43.82 0 0 1-7.849-.922c-2.621-.519-5.219-1.31-7.887-1.55a7.316 7.316 0 0 0-2.816.108c-.687.227-1.352.518-1.985.868a50.53 50.53 0 0 0-4.654 2.953 42.123 42.123 0 0 1-3.723 2.449 20.046 20.046 0 0 0-5.987 4.518c-1.466 1.744-2.156 3.821-1.381 6.037.846 2.403 2.583 4.449 3.948 6.565l.434-.574c-3.218-.69-6.321 1.318-7.755 4.115-1.668 3.178-1.691 7.138-.776 10.54a21.279 21.279 0 0 0 5.282 8.812c2.327 2.519 5.041 4.65 7.298 7.285a11.231 11.231 0 0 1 1.683 2.449c.44.95.67 1.983.675 3.03.046 1.713.147 3.945 1.993 4.727.489.155.884-.511.427-.705Z"/><path fill="#2D0D0D" d="M445.832 161.911c1.675-4.65 5.258-9.905 9.439-12.571a5.925 5.925 0 0 1 2.784-1.092c1.745-.093 3.258 1.139 4.964 1.55 2.986.697 5.863-1.24 8.71-2.387 8.795-3.558 19.002.488 26.246 6.618 4.459 3.774 8.531 9.091 7.756 14.888-.38 3.1-2.087 5.859-3.39 8.703-1.303 2.844-2.233 6.2-1.031 9.059 1.078 2.566 3.761 4.759 3.203 7.479-.59 2.883-4.328 3.774-6.205 6.084-2.28 2.859-1.256 7.385-3.537 10.253-2.505 3.154-7.468 2.549-11.199 1.03"/><path fill="#2D0D0D" d="M448.073 162.531a26.187 26.187 0 0 1 5.197-8.448c2.412-2.588 4.118-3.689 7.569-2.611 5.429 1.697 8.617-1.295 13.736-2.566 10.137-2.534 23.601 4.883 27.867 14.245 2.784 6.13-1.551 10.725-3.312 16.375a12.321 12.321 0 0 0-.24 7.122c.581 1.945 3.149 4.232 3.281 6.154.17 2.325-2.707 3.301-4.158 4.533a9.926 9.926 0 0 0-3.226 5.208c-.644 2.325-.349 5.673-2.575 7.208-2.226 1.534-5.732.356-7.965-.481-2.808-1.054-4.018 3.441-1.241 4.487 3.754 1.403 8.423 2.163 11.936-.279 4.452-3.1 2.412-8.749 5.67-12.268 2.59-2.782 6.662-3.727 6.266-8.377-.178-2.155-1.489-3.674-2.513-5.479-2.218-3.93-.589-7.293 1.179-10.998 2.226-4.65 3.506-9.191 1.551-14.197-1.752-4.433-5.126-8.014-8.841-10.912-7.71-6.006-18.164-9.773-27.665-5.859-1.916.775-4.134 2.325-6.267 2.216-1.598-.054-3.056-1.17-4.599-1.511-2.219-.496-4.251.326-6.073 1.55-4.762 3.255-7.981 8.339-10.036 13.632-1.078 2.798 3.42 4.007 4.49 1.24l-.031.016Z"/><path fill="#1D0F3C" d="M546.767 611.621c-2.645 7.44 4.971 10.85 4.971 10.85s23.059 3.41 44.411-45.655c21.351-49.064 47.528-22.188 47.528-22.188 1.45-28.17-24.23-44.476-24.23-44.476l-21.631 19.072-14.845 21.289a2.23 2.23 0 0 0-.031 2.96c.238.273.539.483.877.613l5.576 2.139-12.409 24.025a49.25 49.25 0 0 1-5.166 8.013l-11.184 14.136-6.375 2.139a11.882 11.882 0 0 0-7.492 7.083Z"/><path fill="#8A4AED" d="m551.715 622.448 38.779-.628a43.007 43.007 0 0 0 31.8-14.632c8.965-10.299 18.544-26.969 21.352-52.598a4.832 4.832 0 0 0-2.327-4.712c-7.376-4.309-28.55-13.175-41.773 17.05-16.21 37.16-26.456 52.102-47.831 55.52ZM574.929 581.769a7.623 7.623 0 0 0 2.249 5.804.773.773 0 0 0 .854.17.78.78 0 0 0 .425-1.024.81.81 0 0 0-.17-.254 6.809 6.809 0 0 1-.458-.496 4.11 4.11 0 0 1-.349-.48 5.584 5.584 0 0 1-.582-1.124 6.912 6.912 0 0 1-.349-1.294s0-.132 0 0v-.551a5.654 5.654 0 0 1 0-.713.774.774 0 1 0-1.551 0l-.069-.038ZM580.575 572.19a6.372 6.372 0 0 0 1.76 6.401.787.787 0 0 0 .255.176.79.79 0 0 0 .607 0 .777.777 0 0 0 .255-.176.77.77 0 0 0 0-1.108 4.645 4.645 0 0 1-1.38-2.255c0-.109-.055-.209-.078-.326l-.047-.201v-1.364c.039-.246.093-.49.163-.729a.764.764 0 0 0-.267-.832.775.775 0 0 0-.276-.136.758.758 0 0 0-.601.069.781.781 0 0 0-.368.481h-.023ZM593.597 556.744a23.754 23.754 0 0 0-10.626.845c-2.931.953-6.763 2.581-7.197 6.076a4.053 4.053 0 0 0 1.621 3.766 6.4 6.4 0 0 0 4.723 1.07 11.946 11.946 0 0 0 7.174-3.201c2.079-2.1 3.32-4.921 4.809-7.432a.78.78 0 1 0-1.357-.775c-2.102 3.549-3.77 7.75-7.989 9.238-2.148.775-6.499 1.55-7.36-1.449-.9-3.1 3.482-4.906 5.716-5.666a22.007 22.007 0 0 1 10.083-.968c.992.139 1.419-1.372.418-1.55l-.015.046Z"/><path fill="#1D0F3C" d="M467.68 576.336c8.361 3.1 36.926-8.153 50.413-11.036 1.637-.349 7.756-5.866 8.152-4.154 1.404 5.572-.109 24.296.93 30.922 1.373 8.796 1.893 14.012 2.645 21.01.675 6.301-67.135 27.032-103.471 30.132-4.654.395-17.063 3.495-20.437.116-6.817-6.82-2.931-17.592 5.91-16.895 10.494.837 20.235-5.665 20.235-5.665l32.04-26.737-5.577-19.468c-.581-1.643 7.601 1.194 9.16 1.775Z"/><path fill="#8A4AED" d="M528.874 603.538s-60.496 27.125-124.738 36.463c0 0-1.334 4.286 7.252 4.968 3.296.256 9.028-.953 15.822-1.744 24.206-2.828 19.537-2.456 27.719-4.092 16.032-3.2 59.395-15.267 71.083-21.978-.9.348 2.955-1.101 3.723-3.155.768-2.053-.861-10.462-.861-10.462ZM467.548 603.461a14.874 14.874 0 0 1-7.438-4.154 1.126 1.126 0 0 1-.162-1.465.947.947 0 0 1 1.033-.343c.124.036.24.098.339.18.469.479.969.927 1.497 1.341.486.386 1.005.729 1.551 1.023.562.317 1.145.594 1.745.829l.45.171.272.093h.077c.326.093.652.178.977.248a1.058 1.058 0 0 1 .776 1.193.982.982 0 0 1-.379.663.99.99 0 0 1-.738.197v.024ZM455.643 611.986a11.38 11.38 0 0 1-5.01-5.766 1.077 1.077 0 0 1 .558-1.349.982.982 0 0 1 .753.03.965.965 0 0 1 .504.559c.108.271.225.535.349.775.062.109.062.124 0 .039l.1.194c.07.124.14.248.218.364.285.473.609.922.969 1.341l.109.124c-.062-.062-.047-.055 0 0l.294.302c.202.194.412.387.629.566.384.328.803.614 1.248.852a1.104 1.104 0 0 1 .505 1.372.968.968 0 0 1-.91.617.984.984 0 0 1-.378-.082l.062.062ZM470.922 590.557a55.447 55.447 0 0 1 11.013-2.441c3.033-.341 6.756-.38 8.749 2.58a4.647 4.647 0 0 1 .527 4.387 7.832 7.832 0 0 1-3.389 3.286 12.417 12.417 0 0 1-9.198 1.007c-3.576-.937-6.709-3.022-9.68-5.277-1.272-.961.241-2.984 1.505-2.023 2.652 2.015 5.499 3.983 8.71 4.789 3.04.775 6.569.442 9.004-1.836a2.108 2.108 0 0 0 .923-2.031 2.835 2.835 0 0 0-1.14-1.55c-1.419-1.038-3.242-.976-4.878-.829a51.036 51.036 0 0 0-11.262 2.371c-1.481.489-2.373-1.914-.884-2.41v-.023Z"/><path fill="#8A4AED" d="M467.905 592.092a17.614 17.614 0 0 0-2.187-7.657c-.822-1.465-2.591-4.069-4.491-2.837-.83.543-.589 1.829-.38 2.666a5.743 5.743 0 0 0 2.001 3.1c1.032.899 2.094 1.744 3.103 2.612a15.243 15.243 0 0 0 3.148 2.271c1.427.674.45 3.038-.977 2.371a15.323 15.323 0 0 1-3.156-2.185l-3.103-2.566a10.367 10.367 0 0 1-2.598-2.852 8.707 8.707 0 0 1-1.055-3.789 4.28 4.28 0 0 1 1.241-3.418 4.138 4.138 0 0 1 3.102-1.008c2.281.155 3.956 2.186 5.057 4.123a20.813 20.813 0 0 1 2.653 8.944c.101 1.658-2.327 1.937-2.412.263l.054-.038Z"/><path fill="#CC3E3E" d="m539.174 333.749 16.497 74.182a70.194 70.194 0 0 0 15.116 30.31l60.814 76.53a4.935 4.935 0 0 1-2.583 7.99l-22.492 3.054a8.984 8.984 0 0 0-1.443.294h-.101a15.84 15.84 0 0 0-8.989 7.254l-11.633 19.785a4.153 4.153 0 0 1-3.204 1.84 4.166 4.166 0 0 1-3.404-1.437l-61.272-61.944a36.709 36.709 0 0 1-6.98-12.3l-40.563-121.572 70.237-23.986Z"/><path fill="#ED5E17" d="M475.661 579.978c-11.813-.666-24.486-2.689-26.006-6.789l-21.212-120.456c-.256-1.411-.605-2.805-.954-4.2a17.14 17.14 0 0 1-.489-3.364 15.962 15.962 0 0 1 1.466-7.2l22.531-50.374a367.737 367.737 0 0 1 9.478-19.607l23.19-44.554 48.536-32.503s48.304 5.727 36.724 56.822c-3.94 17.391-27.363 44.174-38.647 58.217-12.836 15.996-28.34 31.775-34.056 51.607-3.002 10.384 26.145 69.911 33.21 96.695 1.637 6.2-16.582 18.173-22.693 20.615a72.581 72.581 0 0 1-31.078 5.091Z"/><path fill="#00257D" d="M480.718 225.01c5.91-7.06 3.878-11.795 2.412-15.964a5.545 5.545 0 0 1 .892-5.317c3.637-4.603 8.741-10.501 25.889-13.81 20.941-4.038 34.126 4.316 34.126 4.316 34.521 23.483 149.688 132.919 149.688 132.919l-81.499 35.053-91.821-109.274 44.006 56.977c-11.882-4.378-39.206 4.96-51.809 9.757a89.29 89.29 0 0 0-10.61 4.867c-19.056 10.284-20.755 6.286-20.755 6.286l-12.052-22.08a101.684 101.684 0 0 1-4.987-10.408c-.776-1.829-1.668-3.557-2.242-3.875-18.552-9.114-18.164-30.488-17.303-38.478a4.71 4.71 0 0 0-2.428-4.65L337.149 193.98a4.582 4.582 0 0 1-2.037-2.962 4.562 4.562 0 0 1 .734-3.517c14.736-20.987 33.016-69.478 36.452-81.266a.778.778 0 0 1 1.21-.403.782.782 0 0 1 .279.403c2.761 9.448 7.617 42.625 24.819 63.813 0 0 14.325 28.07 42.968 42.376l19.273 14.314s12.161 7.487 19.871-1.728Z"/><path fill="#140404" d="M461.258 226.924c0 1.264-4.134.31-5.212.969-1.078.659-3.932-.139-5.188 0-4.553.481-7.593-4.03-11.355-6.634-3.762-2.604-6.298-7.168-5.786-11.718.419-3.696 2.676-6.889 4.894-9.873 0 0 .279-1.705 3.002 1.101 2.722 2.805 11.796 4.936 11.796 4.936l5.352 14.283 2.497 6.936Z"/><path fill="#2D0D0D" d="M460.483 226.925c.038-.326.232-.132 0-.171a3.264 3.264 0 0 0-.52.078c-.465.046-.938 0-1.404 0a8.113 8.113 0 0 0-2.412.162 6.204 6.204 0 0 1-1 .341 7.66 7.66 0 0 1-1.738-.069 25.309 25.309 0 0 0-3.102-.148c-2.513.055-4.584-1.643-6.375-3.208-.923-.775-1.823-1.635-2.777-2.395a33.46 33.46 0 0 1-3.102-2.464 12.393 12.393 0 0 1-3.607-7.177c-.341-2.937.776-5.704 2.242-8.168.775-1.271 1.776-2.41 2.544-3.674.077-.124.077-.286.085-.24.008.047-.085.178-.147.101.116.147.62.302.775.434.489.364.892.837 1.35 1.24a11.018 11.018 0 0 0 2.164 1.457 40.599 40.599 0 0 0 9.671 3.394l-.543-.534c2.001 5.339 4.057 10.663 5.988 16.026l1.869 5.193c.333.93 1.838.527 1.497-.411a841.506 841.506 0 0 0-3.793-10.377l-3.056-8.161c-.302-.775-.605-1.635-.923-2.456-.232-.613-.581-.775-1.179-.907a38.408 38.408 0 0 1-8.934-3.209 8.944 8.944 0 0 1-1.854-1.278 8.073 8.073 0 0 0-2.21-1.752c-1.055-.457-1.66-.054-2.18.775-.519.829-1.155 1.55-1.675 2.325a24.679 24.679 0 0 0-1.978 3.418 12.93 12.93 0 0 0-1.256 7.083 13.518 13.518 0 0 0 2.629 6.347c1.435 1.915 3.312 3.1 5.111 4.65 1.8 1.55 3.599 3.403 5.77 4.542a8.337 8.337 0 0 0 3.049.953c1.109.109 2.21 0 3.327.124a7.862 7.862 0 0 0 3.102 0 7.082 7.082 0 0 1 2.327-.372c1.272 0 3.63.287 3.808-1.48.109-.984-1.443-.977-1.543.008Z"/><path fill="#BB8874" d="m461.212 226.909-7.803-21.165s-29.992-7.076-19.537-24.149c8.082-13.175 4.956-13.903 5.491-16.019.535-2.115 6.391-1.697 12.231-4.65 5.84-2.952 10.3-5.812 17.467-3.952 7.166 1.86 2.792 18.274 8.896 23.048 0 0 12.184.209 6.608 7.634-5.577 7.424-10.859 7.959-10.859 7.959s1.179 13.407 11.332 11.958c0 0 4.002 13.492-8.214 21.18-.023 0-7.12 3.457-15.612-1.844Z"/><path fill="#2D0D0D" d="M483.293 209.913c3.8 2.984 10.214 1.512 12.339-2.828 1.148-2.325 1.133-5.177 2.536-7.378.877-1.372 2.226-2.372 3.242-3.65 1.016-1.279 1.683-3.1.908-4.518a11.089 11.089 0 0 0-1.652-1.876c-2.056-2.325-1.722-5.82-1.613-8.92a43.276 43.276 0 0 0-4.654-21.072c-1.706-3.363-3.948-6.587-7.128-8.618-3.412-2.178-7.585-2.782-11.633-2.945-2.777-.108-5.701 0-8.129 1.364-.954.535-1.853 1.279-2.947 1.38-1.093.1-2.327-.574-3.443-.985-3.359-1.193-7.252.179-9.765 2.705-2.513 2.527-4.723 4.65-5.476 8.145a34.478 34.478 0 0 0 10.463-3.247c5.894-2.813 9.811-4.875 14.333-.992 2.063 1.767 4.777 3.046 4.777 9.548 0 6.502.28 13.291 2.475 13.996 2.194.705 7.057-.473 7.848 3.829.792 4.301-7.476 10.113-12.316 11.516 0 0-1.233 14.329 8.353 14.244l1.482.302Z"/><path fill="#2D0D0D" d="M482.905 210.58a9.224 9.224 0 0 0 9.392.713 8.607 8.607 0 0 0 3.653-3.185c1.125-1.798 1.358-3.937 1.97-5.921a8.104 8.104 0 0 1 1.552-2.961c.775-.906 1.706-1.681 2.458-2.619 1.133-1.418 1.947-3.433 1.148-5.2a9.933 9.933 0 0 0-1.9-2.286 6.25 6.25 0 0 1-1.295-2.969c-.38-2.123-.086-4.309-.055-6.448a44.142 44.142 0 0 0-2.063-13.841 35.392 35.392 0 0 0-6.205-12.035 18.003 18.003 0 0 0-11.416-6.084c-4.258-.651-9.4-1.077-13.255 1.209-1.171.69-2.11 1.403-3.529.961a24.428 24.428 0 0 0-3.436-1.147 10.225 10.225 0 0 0-6.561 1.325 20.468 20.468 0 0 0-5.034 4.534 13.53 13.53 0 0 0-3.172 5.89.784.784 0 0 0 .424.905c.11.051.23.075.352.071 5.266-.519 9.865-3.1 14.643-5.115 2.769-1.17 5.7-1.906 8.423-.217.91.609 1.776 1.283 2.59 2.015a8.574 8.574 0 0 1 1.784 1.922c1.706 2.666 1.326 6.045 1.388 9.06.062 3.015 0 6.355 1.055 9.222a3.88 3.88 0 0 0 1.551 2.217 6.544 6.544 0 0 0 2.622.488c2.032.147 4.529.31 5.049 2.728.551 2.55-2.164 4.975-3.878 6.417a22.766 22.766 0 0 1-7.833 4.394.78.78 0 0 0-.567.775c-.403 4.743.473 11.493 5.057 14.043 1.668.93 3.514.868 5.321 1.247.969.21 1.388-1.286.411-1.495-1.435-.295-2.986-.248-4.351-.775a6.563 6.563 0 0 1-3.172-2.992c-1.35-2.41-1.722-5.332-1.761-8.06a18.297 18.297 0 0 1 .046-1.945l-.566.775a24.208 24.208 0 0 0 7.337-3.875c2.087-1.55 4.266-3.487 5.228-5.967a4.701 4.701 0 0 0-1.962-5.851 8.247 8.247 0 0 0-3.103-.775c-.907-.093-2.171.062-3.009-.349-.838-.411-1.039-1.721-1.21-2.488a30.688 30.688 0 0 1-.589-5.27c-.163-3.433.364-7.215-.854-10.501-.775-2.015-2.109-3.34-3.738-4.65-2.272-1.836-4.537-3.1-7.554-2.697-4.087.566-7.686 3.1-11.494 4.511a29.697 29.697 0 0 1-6.818 1.774l.776.985a11.614 11.614 0 0 1 2.583-4.983 22.15 22.15 0 0 1 4.141-4.038 9.204 9.204 0 0 1 5.608-1.69c1.993.109 3.707 1.605 5.708 1.395a6.003 6.003 0 0 0 2.459-.999 10.742 10.742 0 0 1 2.885-1.31 20.705 20.705 0 0 1 6.445-.38c4.273.24 8.694 1.116 12.014 3.991 3.149 2.728 5.219 6.611 6.747 10.432a42.684 42.684 0 0 1 2.955 12.903 60.152 60.152 0 0 1 0 6.27 14.617 14.617 0 0 0 .574 5.425c.262.748.65 1.445 1.148 2.061.659.814 1.73 1.45 1.924 2.55.38 2.108-1.73 3.774-3.002 5.107a12.083 12.083 0 0 0-2.87 5.797c-.496 2.007-1.023 3.937-2.629 5.34a7.843 7.843 0 0 1-9.664.465c-.892-.736-1.667.604-.876 1.201Z"/><path fill="#000" d="M440.806 168.452a5.535 5.535 0 0 1-.69-1.45 2.978 2.978 0 0 1-.155-1.449c.116-.449.589-.496.985-.558a50.088 50.088 0 0 1 1.512-.217c.83-.101 1.667-.186 2.482-.349a14.32 14.32 0 0 0 2.714-.852.608.608 0 0 0 .404-.721.583.583 0 0 0-.714-.403c-.972.413-1.986.72-3.025.915-1.008.178-2.024.263-3.04.403a4.536 4.536 0 0 0-1.66.426 1.736 1.736 0 0 0-.83 1.364 5.499 5.499 0 0 0 1.016 3.48c.411.62 1.42.038 1.001-.589Z"/><path fill="#01C9EE" d="M494.601 165.615c3.102-1.875 1.272-.852 4.227-1.914a11.93 11.93 0 0 1 9.159.194 28.286 28.286 0 0 1-7.492 13.779 1.549 1.549 0 0 1-1.008.581 1.457 1.457 0 0 1-.869-.372c-2.962-2.255-3.769-6.277-5.429-9.617a19.174 19.174 0 0 0-7.57-8.122 8.406 8.406 0 0 0-3.769-1.279 1.235 1.235 0 0 0-.861.209 1.357 1.357 0 0 0-.325.581 22.07 22.07 0 0 0 .302 15.244c.124.318.302.667.628.775.296.037.594-.043.83-.224 3.599-2.162 6.313-2.72 8.826-6.092"/><path fill="#0735A4" d="m693.756 327.154-15.985 16.747-30.178 15.981-35.336 2.317 81.499-35.045Z"/><path fill="#BB8874" d="m658.242 329.541 27.099 19.374a10.081 10.081 0 0 0 3.265 1.643c8.532 2.457 47.536 15.167 56.122 26.993 7.368 10.16-54.058-10.075-63.017-3.045-8.958 7.029-4.32 32.247-7.616 34.277-7.756 4.751-10.424-17.049-12.2-27.163a22.076 22.076 0 0 1-.147-1.418 24.523 24.523 0 0 0-12.301-19.375l-28.968-16.569 37.763-14.717Z"/><path fill="#000" d="M707.43 365.756c9.834 1.79 18.373 7.269 27.471 11.082a58.65 58.65 0 0 0 7.849 2.713.779.779 0 0 0 .954-.543.772.772 0 0 0-.543-.953c-9.648-2.511-18.071-8.114-27.363-11.563a47.837 47.837 0 0 0-7.957-2.232c-.97-.178-1.389 1.318-.411 1.496Z"/><path fill="#00257D" d="M281.586 52.39a202.272 202.272 0 0 1 16.659 6.036c1.551.644 3.607-.697 3.956-2.247.426-1.876-.574-3.263-2.25-3.953a197.77 197.77 0 0 0-16.659-6.044 3.244 3.244 0 0 0-3.956 2.247 3.288 3.288 0 0 0 2.25 3.96Z"/><path fill="#fff" d="M294.794 18.724c1.215.92 2.43 1.844 3.645 2.774l.45.349.907.705 1.908 1.55a311.645 311.645 0 0 1 7.221 5.875c1.288 1.077 3.304 1.356 4.553 0 1.093-1.186 1.38-3.395 0-4.55a368.02 368.02 0 0 0-15.473-12.237c-1.35-1.015-3.653-.263-4.398 1.155a3.299 3.299 0 0 0 1.156 4.394l.031-.015Z"/><path fill="#00257D" d="M338.203 3.216a69.938 69.938 0 0 0-.194 10.85l.264 11.013a3.22 3.22 0 0 0 6.438 0l-.264-11.013a69.814 69.814 0 0 1 .194-10.85c.232-1.72-1.644-3.216-3.219-3.216-1.923 0-2.986 1.488-3.219 3.216Z"/><path fill="#fff" d="M375.656 31.372a211.58 211.58 0 0 0 13.185-11.834 3.206 3.206 0 0 0 1.03-2.297 3.217 3.217 0 0 0-4.529-3 3.21 3.21 0 0 0-1.045.747 213.493 213.493 0 0 1-13.185 11.842c-1.303 1.07-1.195 3.449 0 4.542a3.312 3.312 0 0 0 4.552 0h-.008Z"/><path fill="#00257D" d="M383.909 57.721a525.424 525.424 0 0 1 18.211-4.929 3.247 3.247 0 0 0 2.249-3.952 3.285 3.285 0 0 0-3.963-2.248 630.639 630.639 0 0 0-18.211 4.922 3.216 3.216 0 1 0 1.714 6.2v.007Z"/><path fill="#0735A4" d="M112.678 352.992s15.814 55.319-21.32 104.461c-24.27 32.107-49.522 71.19-58.279 84.063a9.184 9.184 0 0 0 2.42 12.756l15.186 11.524c3.467 2.372 7.663.659 10.858-2.108l84.54-86.977c5.514-5.053 14.278-17.158 18.916-23.017l30.248-43.988-82.569-56.714Z"/><path fill="#C88910" d="M190.826 335.578s19.809-.356 25.315-22.916c5.507-22.56 16.156-48.251 16.156-48.251s4.545-7.432 6.127-13.524a9.3 9.3 0 0 1 5.104-6.153c17.163-7.82 61.984-25.738 93.791-109.576 0 0-24.958-7.657-29.922-17.011 0 0-12.037 48.29-79.18 83.242-1.318.689-3.877 1.03-5.219 4.223l-11.781 20.925s10.858 41.516-9.401 78.39c0 0-6.608 11.013-10.462 15.415 0 .023 2.908 10.423-.528 15.236Z"/><path fill="#00257D" d="m192.711 333.857 66.631 79.049a18.302 18.302 0 0 1 4.033 9.579l14.278 143.373a13.218 13.218 0 0 1-3.132 9.912 13.256 13.256 0 0 1-9.331 4.596l-12.293.674a13.248 13.248 0 0 1-8.864-2.767 13.229 13.229 0 0 1-4.864-7.905c-5.484-27.984-22.05-118.317-29.349-126.687-13.96-15.98-34.901-24.025-53.585-33.379a123.244 123.244 0 0 1-42.169-34.355c-33.07-42.624-10.501-71.95-10.501-71.95s51.654 35.952 88.797 27.962"/><path fill="#9ACFFB" d="m190.725 217.074 12.076 9.959a10.154 10.154 0 0 0 8.415-.473s14.17 30.155-.325 60.139c-2.141 4.41-4.189 8.858-5.988 13.415l-12.541 31.775-1.613.356a73.84 73.84 0 0 1-47.102-5.293l-9.028-4.185s34.972-5.51 39.711-32.658c2.784-15.965 7.717-33.084 9.307-38.462a44.42 44.42 0 0 1 1.016-2.992c1.83-4.813 7.965-21.94 6.072-31.581Z"/><path fill="#ED5E17" d="m49.607 637.134 29.31-.38s-28.17-18.67-31.986-44.004c-3.916-26.032-39.314-45.05-45.077-22.002-5.762 23.048 14.674 26.714 15.722 33.526a63.61 63.61 0 0 0 3.102 13.175 30.399 30.399 0 0 0 11.347 14.416 30.436 30.436 0 0 0 17.582 5.269Z"/><path fill="#1D0F3C" d="M2.599 569.082s11.432-24.505 31.489-29.449c0 0 2.412-5.224 21.43 17.011 0 0 2.993 34.448 14.285 45.042 0 0 32.164-10.362 34.01 13.02 1.846 23.381-24.896 22.056-24.896 22.056s-25.02-13.531-31.8-41.524C40.34 567.245 13.55 551.11 2.6 569.082Z"/><path fill="#B17056" d="m211.821 226.56 9.641-24.691s16.892-6.603 15.977-17.616a23.777 23.777 0 0 0-9.144-16.716s3.102-2.015 2.024-4.216c-1.078-2.201-7.903-2.65-7.903-2.65s-8.438-7.991-19.824-5.976c-11.386 2.015-1.838 11.741-4.041 13.214-2.203 1.472-.551 3.301-2.567 5.502-2.017 2.201-5.328-1.1-7.896-2.201-2.567-1.1-8.996 7.89.187 14.121 9.183 6.231-1.862 19.638-1.862 19.638s-1.838 12.849 11.2 20.739c13.037 7.889 14.208.852 14.208.852Z"/><path fill="#000" d="M228.807 168.452a7.145 7.145 0 0 0 1.861-2.759c.236-.553.269-1.17.093-1.744a2.51 2.51 0 0 0-1.016-1.163 22.194 22.194 0 0 0-3.102-1.612 13.87 13.87 0 0 0-3.498-1.116.6.6 0 0 0-.713.403.583.583 0 0 0 .403.713 18.613 18.613 0 0 1 5.739 2.279c.364.156.693.383.97.666a1.25 1.25 0 0 1 0 1.202 5.882 5.882 0 0 1-1.552 2.325c-.55.503.272 1.325.823.821l-.008-.015Z"/><path fill="#1D0F3C" d="M239.929 566.245c-13.527-11.57-22.112 52.971-28.255 68.665a3.042 3.042 0 0 0 .32 2.812c.277.409.648.744 1.083.977.434.234.919.359 1.412.364l121.419 1.302a2.86 2.86 0 0 0 2.846-2.325c1.032-5.843 1.985-20.304-14.31-19.173l-35.196-9.827-12.006-37.974s-27.231 3.805-37.313-4.821Z"/><path fill="#ED6E4C" d="M216.584 627.082c10.454.643 20.94 1.163 31.395 1.635 20.429.923 40.889 1.651 61.349 1.674 9.703 0 19.436-.069 29.116-.86 1.644-.132 1.473-2.689-.179-2.557-8.485.689-17.016.821-25.516.852-10.37.047-20.732-.139-31.094-.418-18.094-.496-36.181-1.287-54.291-2.263-3.668-.194-7.329-.395-10.998-.628-1.644-.101-1.45 2.464.179 2.565h.039ZM267.625 606.522a40.825 40.825 0 0 1 8.857-2.767 63.396 63.396 0 0 1 9.555-.93c2.009-.07 1.854-2.271-.155-2.193-3.481.085-6.951.44-10.377 1.062a43.97 43.97 0 0 0-9.586 3.045c-1.738.775 0 2.558 1.706 1.783ZM255.681 598.152c8.004-4.177 17.885-4.65 27.037-5.844 1.83-.232 1.691-2.433-.155-2.2-9.679 1.247-20.003 1.828-28.464 6.246-1.551.814 0 2.619 1.551 1.798h.031ZM265.562 578.754c3.637-2.953 8.477-3.953 13.069-3.472 4.994.519 9.671 2.836 13.759 5.657 1.334.922 2.52 2 2.008 3.774-.45 1.55-1.815 2.155-3.342 2.023a40.107 40.107 0 0 1-7.803-1.627 58.26 58.26 0 0 1-5.786-1.922c-4.103-1.636-7.756-4.178-11.277-6.766-1.008-.775-1.978.938-.977 1.666a54.376 54.376 0 0 0 11.51 6.874 61.422 61.422 0 0 0 6.794 2.24c1.45.403 2.908.775 4.39 1.039 1.371.329 2.778.483 4.188.457a4.828 4.828 0 0 0 3.234-7.859 13.144 13.144 0 0 0-2.939-2.224 37.11 37.11 0 0 0-3.646-2.123 29.728 29.728 0 0 0-7.934-2.829c-5.809-1.108-11.967-.054-16.621 3.728-.969.775.411 2.146 1.373 1.364Z"/><path fill="#ED6E4C" d="M265.632 575.7c-2.544-.224-5.111.256-7.663.125-1.737-.086-3.436-.202-4.933.883a8.121 8.121 0 0 0-3.18 4.278 26.47 26.47 0 0 0-.667 3.728 6.422 6.422 0 0 0 1.443 4.541 4.564 4.564 0 0 0 1.66 1.395c.829.364 1.884 0 2.691-.302a11.083 11.083 0 0 0 3.878-2.666 44.57 44.57 0 0 0 4.266-4.79 50.03 50.03 0 0 0 3.878-6.2c.597-1.1-1.079-2.076-1.676-.976a41.863 41.863 0 0 1-6.204 8.889 22.694 22.694 0 0 1-3.025 2.953 7.466 7.466 0 0 1-1.652.914 4.394 4.394 0 0 1-1.117.326c-.372.039-.442 0-.776-.271-2.063-1.814-1.434-4.201-.985-6.448a6.2 6.2 0 0 1 2.513-3.782c1.187-.868 2.614-.589 3.971-.535 2.505.093 5.042-.349 7.539-.132 1.241.109 1.233-1.837 0-1.937l.039.007ZM9.758 557.271c7.43-1.837 15.131.574 21.258 4.867 6.508 4.565 11.03 11.369 14.504 18.398 7.158 14.469 10.377 31.449 21.864 43.446 5.692 5.952 13.239 10.354 21.6 10.726 1.249.062 1.249-1.875 0-1.937-7.531-.334-14.356-4.263-19.591-9.502-5.81-5.812-9.61-13.26-12.743-20.769-6.089-14.609-10.54-31.597-23.904-41.493-6.67-4.945-15.28-7.634-23.5-5.604-1.21.295-.698 2.163.512 1.868ZM58.224 577.739c0 .1-.07.193-.109.286l.101-.232a5.391 5.391 0 0 1-.675 1.155l.148-.194a5.072 5.072 0 0 1-.884.891l.194-.155-.062.047a1.06 1.06 0 0 0-.443.581.96.96 0 0 0 .093.775c.13.219.338.379.582.449a.925.925 0 0 0 .776-.1c.276-.187.535-.397.775-.628.232-.242.444-.501.636-.775.334-.476.595-.998.776-1.55a.96.96 0 0 0-.093-.775.992.992 0 0 0-1.357-.349 1.072 1.072 0 0 0-.45.574h-.008ZM61.063 587.039c.106.272.182.555.225.844l-.04-.255c.043.342.043.688 0 1.03v-.263a3.966 3.966 0 0 1-.255.945l.093-.232a2.322 2.322 0 0 1-.132.279.966.966 0 0 0 .062 1.077.972.972 0 0 0 1.613-.093 4.709 4.709 0 0 0 .264-3.875 1.114 1.114 0 0 0-.45-.581.997.997 0 0 0-.775-.093.984.984 0 0 0-.716.819.915.915 0 0 0 .04.398h.07Z"/><path fill="#BB8874" d="m81.29 344.351 30.046 17.825s13.868 7.238 29.791 2.325c0 0 7.686-3.72 7.112-7.688 0 0 12.882 1.294 16.163-10.548 0 0 6.057-.434 5.429-5.867-.628-5.432-1.745-6.649-7.484-7.447 0 0-8.687-15.678-20.941-11.54 0 0-9.191 4.782-12.642 9.657a1.769 1.769 0 0 1-2.637.302l-21.662-19.452s-17.49 5.649-23.175 32.433Z"/><path fill="#000" d="M127.321 331.292a10.868 10.868 0 0 0-8.314 3.875.892.892 0 0 0 0 1.232.875.875 0 0 0 1.233 0 9.15 9.15 0 0 1 7.081-3.355.877.877 0 0 0 .566-1.462.876.876 0 0 0-.566-.282v-.008ZM143.973 342.568a8.436 8.436 0 0 1 3.475 4.65 21.811 21.811 0 0 1 1.279 6.045c.109 2.116-.271 4.317-1.799 5.898a10.43 10.43 0 0 1-5.569 2.635c-1.101.217-.636 1.899.466 1.674a11.932 11.932 0 0 0 6.336-3.1 9.207 9.207 0 0 0 2.327-6.828 22.509 22.509 0 0 0-1.497-7.207 10.078 10.078 0 0 0-4.126-5.309.877.877 0 0 0-.884 1.504l-.008.038ZM155.165 340.119a8.093 8.093 0 0 1 3.493 10.366 8.08 8.08 0 0 1-2.446 3.119c-.869.713.372 1.938 1.233 1.232a9.941 9.941 0 0 0 3.599-8.586 10.08 10.08 0 0 0-5.003-7.634.87.87 0 1 0-.876 1.503ZM164.425 339.143c.306.343.566.723.776 1.131.236.416.413.862.527 1.326.249.907.278 1.861.086 2.782a.9.9 0 0 0 .612 1.077.884.884 0 0 0 1.071-.612 7.827 7.827 0 0 0-1.87-6.936.9.9 0 0 0-1.24 0 .89.89 0 0 0 0 1.232h.038Z"/><path fill="#ED6E4C" d="M52.236 563.789a27.563 27.563 0 0 1 8.245-1.736c2.063-.101 4.739-.194 6.445 1.209 1.706 1.403 1.094 4.131-.59 5.347-2.04 1.473-4.808 1.085-6.98.233-2.986-1.17-5.762-3.1-8.531-4.65a.969.969 0 0 0-1.33.345.97.97 0 0 0 .345 1.329c2.978 1.705 5.933 3.712 9.152 4.913 2.699 1.008 6.01 1.194 8.454-.558 2.086-1.488 3.164-4.402 2.04-6.789-1.125-2.387-4.026-3.169-6.477-3.309a28.186 28.186 0 0 0-11.261 1.814c-1.164.434-.66 2.325.512 1.867l-.024-.015Z"/><path fill="#F3B003" d="M160.47 204.783h-41.727a25.451 25.451 0 0 0-11.192 2.589c-19.475 9.509-85.012 43.166-85.485 65.657-.55 26.419 60.946 72.422 60.946 72.422s3.102-19.328 30.178-24.737c0 0-28.875-37.773-24.47-42.733 4.406-4.96 26.44-19.809 32.497-16.507 6.058 3.301-10.005 13.453-15.853 20.668-3.746 4.65-14.441 11.253-12.239 15.655 2.203 4.402 34.7 32.472 54.532 23.668 19.832-8.803 27.541-23.118 30.845-46.235 3.304-23.118 13.185-36.874 13.185-40.726 0-3.658 4.475-30.659-20.095-46.089a2.963 2.963 0 0 0-4.034.815 2.95 2.95 0 0 0-.511 1.41l-.776 8.803a5.848 5.848 0 0 1-5.801 5.34Z"/><path fill="#00257D" d="M544.029 194.235c34.521 23.483 149.688 132.919 149.688 132.919l-81.498 35.053-91.822-109.274"/><path fill="#000" d="M87.596 283.313c2.49 4.898 5.731 9.47 8.756 14.043a2370.846 2370.846 0 0 0 11.688 17.336c1.45 2.162 2.916 4.309 4.312 6.51.667 1.046 2.327.077 1.676-.977-6.702-10.547-14.085-20.645-20.778-31.193-1.389-2.185-2.8-4.386-3.98-6.696-.565-1.108-2.24-.132-1.674.977ZM651.425 363.656a16.505 16.505 0 0 0 9.307.775.969.969 0 0 0-.512-1.868 14.658 14.658 0 0 1-8.314-.775.99.99 0 0 0-1.195.682.993.993 0 0 0 .683 1.186h.031ZM94.894 451.229c1.489 6.2 7.639 8.998 12.952 11.215a.98.98 0 0 0 1.195-.675 1 1 0 0 0-.683-1.193c-4.654-1.953-10.284-4.433-11.634-9.858-.287-1.217-2.156-.705-1.869.511h.039ZM251.4 434.87c2.807-.597 5.669-1.403 7.98-3.186a9.043 9.043 0 0 0 3.708-6.61c.062-1.248-1.885-1.248-1.939 0a7.202 7.202 0 0 1-3.18 5.262c-2.094 1.48-4.607 2.139-7.081 2.666-1.226.255-.706 2.123.512 1.868ZM236.439 555.59c8.353 7.447 20.01 7.641 30.558 6.835 1.233-.093 1.241-2.031 0-1.938-9.974.775-21.259.775-29.186-6.269-.93-.822-2.326.542-1.372 1.372ZM40.192 529.573a41.034 41.034 0 0 1 23.058 20.398c.558 1.116 2.234.139 1.675-.977a43.005 43.005 0 0 0-24.221-21.289c-1.18-.41-1.684 1.465-.512 1.868ZM447.949 565.261a97.114 97.114 0 0 0 54.904-6.2 94.367 94.367 0 0 0 14.046-7.401c1.047-.674.077-2.325-.977-1.674a95.065 95.065 0 0 1-52.066 14.865 92.442 92.442 0 0 1-15.387-1.45c-1.226-.224-1.745 1.643-.52 1.868v-.008ZM572.183 546.607a63.438 63.438 0 0 1 32.955-34.874c1.132-.512.147-2.186-.978-1.674a65.658 65.658 0 0 0-28.976 25.985 64.307 64.307 0 0 0-4.87 10.075c-.45 1.163 1.427 1.666 1.869.512v-.024ZM428.032 453.469a29.495 29.495 0 0 0 13.589 1.217.98.98 0 0 0 .587-.456.98.98 0 0 0 .095-.738.999.999 0 0 0-1.194-.674 27.296 27.296 0 0 1-12.557-1.216c-1.187-.403-1.699 1.464-.52 1.867ZM604.246 353.573a671 671 0 0 1 45.465-25.047 736.154 736.154 0 0 1 13.185-6.441c1.124-.534.147-2.208-.978-1.674a683.436 683.436 0 0 0-46 24.025 659.581 659.581 0 0 0-12.681 7.448.972.972 0 1 0 .985 1.674l.024.015ZM465.415 296.643a28.201 28.201 0 0 0 10.37-2.93 1.458 1.458 0 0 0-1.474-2.511 24.835 24.835 0 0 1-8.896 2.534 1.49 1.49 0 0 0-1.45 1.457 1.466 1.466 0 0 0 1.45 1.45ZM483.89 210.107a42.453 42.453 0 0 0 5.289-8.881c.303-.674-.698-1.263-1-.581a43.396 43.396 0 0 1-5.29 8.881.584.584 0 0 0 .202.775.597.597 0 0 0 .776-.209l.023.015ZM498.432 182.549a7.55 7.55 0 0 0 3.219 9.485c.659.349 1.249-.651.589-1.007a6.38 6.38 0 0 1-2.8-7.889c.295-.682-.705-1.271-1.008-.589ZM77.055 339.817c2.684-9.083 10.711-14.887 18.071-20.15 1.017-.72.047-2.402-.977-1.674-7.802 5.534-16.124 11.664-18.963 21.274a.968.968 0 0 0 1.87.511v.039ZM185.009 228.994a35.006 35.006 0 0 0-19.498 14.724.878.878 0 0 0 .776 1.31c2.071-.039 5.871.519 4.211 3.464-.776 1.333-1.706 2.504-2.381 3.875a22.646 22.646 0 0 0-1.551 4.162c-1.629 6.254-.776 12.756.357 19.003.775 4.045 1.652 8.067 2.086 12.159.116 1.109 1.869 1.116 1.745 0-.776-7.525-3.164-14.856-3.351-22.474a28.403 28.403 0 0 1 1.288-9.742 18.78 18.78 0 0 1 2.218-4.557c.846-1.263 1.924-2.557 1.73-4.193-.357-2.968-3.971-3.526-6.383-3.479l.775 1.317a33.124 33.124 0 0 1 18.452-13.903.88.88 0 0 0 .538-1.054.874.874 0 0 0-1.004-.628l-.008.016ZM164.402 204.915a46.12 46.12 0 0 1 17.474 21.459c.403 1.031 2.094.581 1.683-.465a48.116 48.116 0 0 0-18.273-22.474c-.946-.62-1.815.891-.884 1.503v-.023ZM215.149 237.751a39.193 39.193 0 0 1 6.98 9.432 13.228 13.228 0 0 1 1.675 4.719 4.511 4.511 0 0 1-.264 2.201 4.683 4.683 0 0 1-1.667 1.775c-1.357 1.101-1.621 2.612-1.365 4.278.302 1.961.776 3.728.465 5.735-.612 4.2-2.947 7.982-4.917 11.663l-7.034 13.175c-.528.985.977 1.868 1.504.876l6.678-12.493c2.024-3.797 4.405-7.649 5.297-11.911a14.315 14.315 0 0 0 0-6.022 7.532 7.532 0 0 1-.326-2.588c.132-1.047.993-1.457 1.722-2.085 2.637-2.271 1.683-6.161.404-8.889a39.845 39.845 0 0 0-7.88-11.098.88.88 0 0 0-1.2.033.875.875 0 0 0-.041 1.199h-.031ZM273.147 176.728a20.012 20.012 0 0 0 8.532 7.588c.201.11.436.139.658.081a.894.894 0 0 0 .536-.391.878.878 0 0 0-.31-1.194 18.424 18.424 0 0 1-7.896-6.975c-.589-.953-2.102-.077-1.504.884l-.016.007ZM300.425 128.292c5.716 7.866 14.402 12.554 22.841 16.964.992.519 1.877-.984.876-1.503-8.128-4.255-16.698-8.742-22.213-16.345-.651-.899-2.164 0-1.504.884ZM111.802 206.961a17.998 17.998 0 0 1 6.91 6.2.872.872 0 0 0 1.505-.876 19.675 19.675 0 0 0-7.539-6.835.877.877 0 0 0-.66-.09.867.867 0 0 0-.641.725.875.875 0 0 0 .425.868v.008Z"/><path fill="#C88910" d="m122.148 282.088 15.263 12.152-29.177 7.851.985-4.193a22.994 22.994 0 0 1 11.168-14.826l1.761-.984Z" opacity=".66"/><path fill="#000" d="M236.927 242.633a23.61 23.61 0 0 1-2.862 14.074c-.481.868.853 1.651 1.342.775a25.07 25.07 0 0 0 3.102-14.856c-.1-.985-1.652-1-1.551 0l-.031.007ZM123.59 265.627a47.914 47.914 0 0 0 9.37-11.229.892.892 0 0 0-1.012-1.302.895.895 0 0 0-.54.418 46.164 46.164 0 0 1-9.09 10.85c-.845.737.396 1.969 1.234 1.233l.038.03ZM31.691 273.804a11.757 11.757 0 0 0 4.405-8.161.874.874 0 0 0-.876-.868.891.891 0 0 0-.869.868 10.07 10.07 0 0 1-3.878 6.928.873.873 0 0 0 1.234 1.233h-.016ZM190.214 284.258c2.612 2 5.608 3.441 8.803 4.232a.877.877 0 0 0 .457-1.682 22.725 22.725 0 0 1-8.376-4.053.878.878 0 0 0-1.195.31.898.898 0 0 0 .311 1.193ZM446.274 252.925a9.45 9.45 0 0 1 4.491-7.083.879.879 0 0 0 .243-1.154.882.882 0 0 0-1.128-.35 11.304 11.304 0 0 0-3.692 3.662 11.277 11.277 0 0 0-1.659 4.925.875.875 0 0 0 .868.876.903.903 0 0 0 .877-.876ZM505.498 235.194a101.726 101.726 0 0 0 13.681 22.087c.706.876 1.939-.364 1.233-1.232a100.218 100.218 0 0 1-13.41-21.739c-.465-1.015-1.969-.132-1.504.884ZM375.447 183.99a17.627 17.627 0 0 0 2.948-4.348 1.165 1.165 0 0 0-.412-1.588 1.183 1.183 0 0 0-.883-.114 1.183 1.183 0 0 0-.714.532c-.351.738-.752 1.45-1.203 2.131-.108.163-.217.318-.333.473-.116.155-.124.178-.194.264-.07.085-.124.162 0 0 .124-.163 0 0 0 0-.256.333-.535.651-.814.961a1.16 1.16 0 0 0 .83 1.954c.302.006.593-.106.814-.311l-.039.046ZM474.699 196.444a15.592 15.592 0 0 0 8.338-3.1.594.594 0 0 0 .209-.775.586.586 0 0 0-.775-.209 14.525 14.525 0 0 1-7.756 2.976c-.776.054-.776 1.217 0 1.162l-.016-.054ZM477.142 183.269c-.747.212-1.471.495-2.164.845-.362.13-.682.358-.923.659a.905.905 0 0 0 .412 1.193c.301.181.636.3.985.349.308.023.609.099.891.225a.837.837 0 0 1 .249.209c0 .047 0 .132.046.062-.101.233-.504.372-.713.488-.757.41-1.552.745-2.374 1-.713.225-.411 1.349.311 1.124a15.764 15.764 0 0 0 2.194-.884c.621-.31 1.482-.658 1.683-1.387a1.544 1.544 0 0 0-.969-1.697 3.847 3.847 0 0 0-.977-.256c-.148 0-.31-.054-.458-.101l-.178-.077c-.117-.062-.086-.109-.062 0v.31c-.163.147-.186.178-.086.108l.156-.093.325-.17c.21-.116.427-.217.652-.318a11.38 11.38 0 0 1 1.311-.449.584.584 0 0 0-.311-1.124v-.016ZM188.445 177.263l-.326 1.209a2.675 2.675 0 0 0-.17 1.178c.155.837 1.016.977 1.722.86.364-.062.775-.147 1.101-.217.373-.094.751-.166 1.132-.217h.14s.124.055.078 0c-.047-.054.054.055 0 0l.046.078a.562.562 0 0 1 0 .116c0 .07 0 .078 0 0a.818.818 0 0 1 0 .14.504.504 0 0 1 0 .155 4.026 4.026 0 0 1-.194.596.583.583 0 0 0 .403.713.586.586 0 0 0 .714-.41 2.041 2.041 0 0 0-.147-2.209c-.629-.659-1.551-.333-2.327-.178l-1.171.232h-.101c.062 0 .054 0 0 0h-.272c.063 0 .063 0 0 0-.062 0-.062 0 0 0v-.093c0-.178.093-.356.14-.535l.318-1.209a.578.578 0 0 0-.416-.667.58.58 0 0 0-.701.357l.031.101ZM349.387 71.911c.838 3.875 1.552 7.804 2.001 11.75.381 3.099.295 6.672 2.475 9.183.651.775 1.745-.341 1.093-1.093a8.229 8.229 0 0 1-1.613-4.464c-.217-1.705-.372-3.41-.597-5.107a134.186 134.186 0 0 0-1.862-10.68c-.209-.976-1.706-.565-1.497.411ZM332.076 73.787c-.535 2.976-1 5.967-1.815 8.881-.775 2.782-1.853 5.735-4.056 7.711-.776.667.357 1.76 1.094 1.093 2.28-2.046 3.482-5.053 4.327-7.92a89.247 89.247 0 0 0 1.939-9.355c.179-.976-1.318-1.395-1.489-.41ZM213.349 163.957c2.242 0 2.249-3.488 0-3.488s-2.249 3.488 0 3.488ZM456.473 165.507c2.249 0 2.249-3.488 0-3.488s-2.249 3.488 0 3.488ZM360.975 49.196c-2.428 4.294-2.8 9.3-3.103 14.097-.062.992 1.489.992 1.551 0 .28-4.541.598-9.3 2.878-13.314a.778.778 0 0 0-.317-.99.777.777 0 0 0-1.017.215l.008-.008ZM315.89 49.429a152.111 152.111 0 0 1 3.436 15.314c.162.984 1.659.565 1.496-.411a151.556 151.556 0 0 0-3.436-15.314.783.783 0 0 0-.364-.469.778.778 0 0 0-1.154.578.769.769 0 0 0 .022.302Z"/><path fill="#fff" d="M436.68 174.915c3.164 1.93 6.6 3.921 10.292 3.627a21.484 21.484 0 0 1-3.831 2.743 7.147 7.147 0 0 1-4.569.775 2.458 2.458 0 0 1-1.38-.93 4.973 4.973 0 0 1-.621-1.751 15.474 15.474 0 0 1-.046-3.495l.155-.969Z"/><path fill="#000" d="M436.486 175.256c3.165 1.922 6.639 3.945 10.486 3.673l-.271-.666a20.058 20.058 0 0 1-3.878 2.767 7.54 7.54 0 0 1-2.412.736 3.65 3.65 0 0 1-2.242-.271c-1.163-.698-1.272-2.364-1.295-3.589-.01-.965.063-1.929.217-2.882.078-.489-.675-.698-.776-.21a17.13 17.13 0 0 0-.232 3.503c.077 1.418.341 3.054 1.667 3.875 1.327.822 3.483.364 4.886-.225a18.43 18.43 0 0 0 4.654-3.1.39.39 0 0 0 .082-.418.386.386 0 0 0-.353-.24c-3.716.255-7.043-1.713-10.083-3.573-.489-.31-.876.357-.45.62Z"/><path fill="#fff" d="M222.09 174.38c3.843.472 7.739.233 11.494-.705a9.98 9.98 0 0 1-1.783 4.518 4.69 4.69 0 0 1-4.289 1.868 5.587 5.587 0 0 1-2.327-1.085 13.8 13.8 0 0 1-3.932-4.301l.837-.295Z"/><path fill="#000" d="M222.09 174.745c3.889.465 7.831.223 11.634-.713l-.481-.481c-.481 2.627-1.792 6.022-4.956 6.153-1.489.062-2.839-.968-3.878-1.906a13.961 13.961 0 0 1-2.761-3.34l-.233.565.838-.294c.465-.163.264-.914-.209-.775l-.83.295a.379.379 0 0 0-.255.226.374.374 0 0 0-.028.172.377.377 0 0 0 .05.167 14.587 14.587 0 0 0 3.188 3.767c1.217 1.007 2.668 1.991 4.327 1.852 3.429-.279 4.98-3.751 5.523-6.704a.395.395 0 0 0-.481-.48 31.842 31.842 0 0 1-11.448.721c-.488 0-.481.775 0 .775Z"/><path fill="#753D2C" d="M227.519 198.653a25.604 25.604 0 0 1-8.213 1.41c-2.327.055-3.669-.279-7.081-2.053a.407.407 0 0 0-.454.053.406.406 0 0 0-.112.443l3.257 7.106c.124.341 2.598 6.2 2.738 5.89l2.963-7.533.853-2.123a39.028 39.028 0 0 0 6.049-3.193ZM446.856 202.993s8.151 3.743 15.573 1.55a.864.864 0 0 1 1.009 1.24l-6.073 10.726-3.832-10.378-6.677-3.138Z" opacity=".37"/></svg>	
				</div>
			</div>
		</div>
	</section>
	<section class="tutor-mb-32 tutor-mb-xl-40" style="margin-top: -140px;">
		<div class="tutor-container">
			<div class="tutor-row tutor-gx-xl-5">
				<div class="tutor-col-lg-6 tutor-mb-32 tutor-mb-lg-0">
					<div class="tutor-welcome-card">
						<div class="tutor-px-32 tutor-px-xl-72 tutor-pt-32 tutor-pt-xl-72">
							<div class="tutor-fs-3 tutor-fw-medium tutor-color-black tutor-mb-12">More Organized <br class="tutor-d-none tutor-d-lg-block"/>Dashboard</div>
							<div class="tutor-fs-6 tutor-color-secondary">Get great improvements to the dashboard offering a more intuitive, organized, and modern approach.</div>
						</div>
						<div>
							<img class="tutor-img-responsive" src="<?php echo esc_url( $image_url ); ?>/dashboard.png" srcset="<?php echo esc_url( $image_url ); ?>/dashboard-2x.png 2x" alt="Dashboard" loading="lazy">
						</div>
					</div>
				</div>

				<div class="tutor-col-lg-6">
					<div class="tutor-welcome-card tutor-px-24 tutor-px-xl-48 tutor-pt-24 tutor-pt-xl-48 tutor-pb-20 tutor-pb-xl-32 tutor-mb-32 tutor-mb-xl-40">
						<div class="tutor-row tutor-align-center">
							<div class="tutor-col-lg-6 tutor-d-flex tutor-justify-center tutor-d-xl-block">
								<div>
									<img class="tutor-img-responsive" src="<?php echo esc_url( $image_url ); ?>/design-system.png" srcset="<?php echo esc_url( $image_url ); ?>/design-system-2x.png 2x" alt="Unified Design" loading="lazy">
								</div>
							</div>
							<div class="tutor-col-lg-6">
								<div class="tutor-fs-3 tutor-fw-medium tutor-color-black tutor-mb-0">Unified Design <br class="tutor-d-none tutor-d-lg-block"/>System</div>
								<div class="tutor-fs-6 tutor-color-secondary tutor-mt-12 tutor-mb-16">Bring an aligned and enhanced user experience with <strong>Appearance, Colors, Accessibility</strong>, and more.</div>
							</div>
						</div>
					</div>
					<div class="tutor-welcome-card">
						<div class="tutor-row tutor-align-center">
							<div class="tutor-col-lg-6 tutor-d-flex tutor-justify-center tutor-d-xl-block">
								<div>
									<img class="tutor-img-responsive" src="<?php echo esc_url( $image_url ); ?>/analytics.png" srcset="<?php echo esc_url( $image_url ); ?>/analytics-2x.png 2x" alt="Analytics" loading="lazy">
								</div>
							</div>
							<div class="tutor-col-lg-6">
								<div class="tutor-px-32 tutor-px-lg-0 tutor-pt-32 tutor-pt-xl-48 tutor-pb-24 tutor-pb-xl-32">
									<div class="tutor-fs-3 tutor-fw-medium tutor-color-black tutor-mb-12">Advanced <br class="tutor-d-none tutor-d-lg-block"/>Analytics</div>
									<div class="tutor-fs-6 tutor-color-secondary tutor-mb-16">Get detailed insights on courses, students, earnings, statements, and do so much more with advanced analytics.</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>

	<section class="tutor-mb-32 tutor-mb-xl-40">
		<div class="tutor-container">
			<div class="tutor-welcome-card">
				<div class="tutor-row tutor-align-center">
					<div class="tutor-col-lg-5 tutor-col-xl-4">
						<div class="tutor-pl-32 tutor-pl-xl-48 tutor-pt-32 tutor-pt-xl-48 tutor-pb-24 tutor-pb-xl-32">
							<div class="tutor-fs-3 tutor-fw-medium tutor-color-black tutor-mb-12">Customizable <br class="tutor-d-none tutor-d-lg-block"/>Automated Emails</div>
							<div class="tutor-fs-6 tutor-color-secondary tutor-mb-32">Edit email template content right from the settings. Get pre designed templates, set emails, see reviews, and do more.</div>
							<div class="tutor-row tutor-gx-xl-5">
								<div class="tutor-col-6">
									<div class="tutor-mb-8">
										<svg xmlns="http://www.w3.org/2000/svg" width="59" height="58" fill="none"><circle cx="29.5" cy="29" r="29" fill="#1F3BD8" opacity=".08"/><path fill="#1F3BD8" d="M40.519 17.756a4.726 4.726 0 0 1 4.724 4.725v14.55a4.726 4.726 0 0 1-4.724 4.725H18.484a4.726 4.726 0 0 1-4.724-4.724V22.48a4.726 4.726 0 0 1 4.724-4.725H40.52Zm0 2.192H18.484a2.504 2.504 0 0 0-2.513 2.476v14.608a2.504 2.504 0 0 0 2.476 2.513h22.11a2.504 2.504 0 0 0 2.513-2.476V22.461a2.504 2.504 0 0 0-2.476-2.513h-.076Z"/><path fill="#1F3BD8" d="M32.053 30.153a4.801 4.801 0 0 1-4.951.038l-.057-.038-6.33-3.968a1.098 1.098 0 0 1-.34-1.512 1.117 1.117 0 0 1 1.473-.378l.038.019 6.33 3.969c.775.491 1.834.491 2.627.037l.057-.037 6.33-3.969c.511-.321 1.192-.17 1.513.36.32.51.17 1.152-.322 1.492l-.038.02-6.33 3.967Z"/></svg>
									</div>
									<div class="tutor-fs-6 tutor-fw-medium">Get Pre-designed Email Templates</div>
								</div>

								<div class="tutor-col-6">
									<div class="tutor-mb-8">
										<svg xmlns="http://www.w3.org/2000/svg" width="59" height="58" fill="none"><circle cx="29.5" cy="29" r="29" fill="#1F3BD8" opacity=".08"/><path fill="#1F3BD8" d="m43.64 15.672-5.26-2.724a1.108 1.108 0 0 0-1.45.487l-8.16 15.789c-.113.214-.151.46-.111.697l.83 4.861a1.108 1.108 0 0 0 1.572.808l4.43-2.214c.214-.105.388-.275.498-.487l8.127-15.734a1.108 1.108 0 0 0-.477-1.484Zm-9.445 15.921-2.801 1.351-.52-3.033 7.473-14.472 3.321 1.694-7.473 14.46Zm9.378-5.668v11.382a5.536 5.536 0 0 1-5.536 5.536h-15.5A5.536 5.536 0 0 1 17 37.307V21.806a5.536 5.536 0 0 1 5.536-5.536h8.659a1.107 1.107 0 0 1 0 2.214h-8.659a3.322 3.322 0 0 0-3.322 3.322v15.5a3.322 3.322 0 0 0 3.322 3.323h15.501a3.322 3.322 0 0 0 3.322-3.322V25.925a1.107 1.107 0 1 1 2.214 0Z"/></svg>	
									</div>
									<div class="tutor-fs-6 tutor-fw-medium">Handy Email Templates Editor</div>
								</div>
							</div>
						</div>
					</div>
					<div class="tutor-col-lg-7 tutor-col-xl-8 tutor-d-none tutor-d-lg-block">
						<img class="tutor-img-responsive" src="<?php echo esc_url( $image_url ); ?>/email-templates.png" srcset="<?php echo esc_url( $image_url ); ?>/email-templates-2x.png 2x" alt="Email Templates" loading="lazy">
					</div>
				</div>
			</div>
		</div>
	</section>

	<section class="tutor-mb-40 tutor-mb-xl-80">
		<div class="tutor-container">
			<div class="tutor-row tutor-gx-xl-5">
				<div class="tutor-col-lg-6 tutor-mb-32 tutor-mb-lg-0">
					<div class="tutor-welcome-card tutor-px-32 tutor-pt-44">
						<div class="tutor-row">
							<div class="tutor-col-xl-6 tutor-d-flex tutor-justify-center tutor-d-xl-block">
								<div>
									<img class="tutor-img-responsive" src="<?php echo esc_url( $image_url ); ?>/notifications.png" srcset="<?php echo esc_url( $image_url ); ?>/notifications-2x.png 2x" alt="Notifications" loading="lazy">
								</div>
							</div>

							<div class="tutor-col-xl-6">
								<div class="tutor-py-32">
									<div class="tutor-fs-3 tutor-fw-medium tutor-color-black tutor-mb-12">Notifications</div>
									<div class="tutor-fs-6 tutor-color-secondary">
										Enhance the overall LMS experience by informing users of new announcements, comments, questions, and more.
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>

				<div class="tutor-col-lg-6">
					<div class="tutor-welcome-card tutor-px-32 tutor-py-44">
						<div class="tutor-row">
							<div class="tutor-col-xl-4 tutor-d-flex tutor-justify-center tutor-d-xl-block">
								<svg xmlns="http://www.w3.org/2000/svg" width="155" height="155" fill="none"><circle cx="77.5" cy="77.5" r="77.5" fill="#3E64DE" fill-opacity=".1"/><path fill="#3E64DE" d="M97.857 72.41H82.59V57.144a3.393 3.393 0 0 0-3.393-3.393h-3.392a3.393 3.393 0 0 0-3.393 3.393V72.41H57.143a3.393 3.393 0 0 0-3.393 3.393v3.392a3.393 3.393 0 0 0 3.393 3.393H72.41v15.268a3.393 3.393 0 0 0 3.393 3.393h3.392a3.393 3.393 0 0 0 3.393-3.393V82.59h15.268a3.393 3.393 0 0 0 3.393-3.393v-3.392a3.393 3.393 0 0 0-3.393-3.393Z"/></svg>
							</div>

							<div class="tutor-col-xl-8 tutor-mt-24 tutor-mt-xl-0">
								<div class="tutor-fs-3 tutor-fw-medium tutor-color-black tutor-mb-12">And more…</div>
								<div class="tutor-fs-6 tutor-color-secondary">
									Communication enhanced with more options, new assignments options, course catalog & details revamped, settings restructured, and made changes to many more things.
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>

	<section>
		<div class="tutor-container">
			<div class="tutor-row tutor-justify-center tutor-gx-xl-5">
				<div class="tutor-col-lg-4 tutor-col-xl-3 tutor-mb-24 tutor-mb-lg-0">
					<a class="tutor-btn tutor-btn-primary tutor-d-block" href="<?php echo esc_url( admin_url( 'post-new.php?post_type=' . tutor()->course_post_type ) ); ?>">
						<?php esc_html_e( "Let's Start Building", 'tutor' ); ?>
					</a>
				</div>
				<div class="tutor-col-lg-4 tutor-col-xl-3">
					<a target="_blank" class="tutor-btn tutor-btn-outline-primary tutor-d-block" 
					href="https://tutorlms.com/pricing/?utm_source=wizard&utm_medium=wp_dashboard&utm_campaign=free_vs_pro" rel="noreferrer noopener">
						<?php esc_html_e( 'Compare Free vs Pro', 'tutor' ); ?>
					</a>
				</div>
			</div>
		</div>
	</section>
</div>

